package ga.view.examples.simple;

import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.individual.IndividualList;
import ga.core.validation.GAContext;

/**
 * Crossover operator for the simple object example.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class SimpleObjectCrossoverOp extends ProbabilityOp implements
    ICrossoverOp<SimpleObjectIndividual> {

  /**
   * Instantiates a new simple object crossover op.
   * 
   * @param pCrossover
   *          the crossover
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public SimpleObjectCrossoverOp(final int pCrossover) {
    super(pCrossover);
  }

  @Override
  public IndividualList<SimpleObjectIndividual> crossover(
      final SimpleObjectIndividual individual1,
      final SimpleObjectIndividual individual2, final GAContext context) {
    final IndividualList<SimpleObjectIndividual> list = new IndividualList<SimpleObjectIndividual>();

    final SimpleObjectIndividual ind1 = individual1.clone();
    final SimpleObjectIndividual ind2 = individual2.clone();

    if (doOperate()) {
      final int iCut = getRandom().nextInt(
          SimpleObjectIndividual.NUM_PARAMETERS);
      for (int i = 0; i < SimpleObjectIndividual.NUM_PARAMETERS; i++) {
        if (i >= iCut) {
          // switch parameters between the two individuals
          final Number num = ind1.getGenotype().get(i);
          ind1.getGenotype().set(i, ind2.getGenotype().get(i));
          ind2.getGenotype().set(i, num);
        }
      }
    }

    list.add(ind1);
    list.add(ind2);
    return list;
  }
}
